/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import java.io.File;
import java.nio.file.Files;

public class AdminDeleteMain {
    public static void main(String[] args) {
        block9: {
            if (args.length < 1) {
                System.err.println("Usage: AdminDeleteMain <file_path>");
                System.exit(1);
            }
            String filePath = args[0];
            System.out.println("AdminDeleteMain: Attempting to delete file: " + filePath);
            try {
                File file = new File(filePath);
                if (file.exists()) {
                    boolean deleted = file.delete();
                    if (!deleted) {
                        try {
                            Files.deleteIfExists(file.toPath());
                            deleted = true;
                            System.out.println("AdminDeleteMain: NIO deletion successful");
                        }
                        catch (Exception nioEx) {
                            System.err.println("AdminDeleteMain: NIO deletion failed: " + nioEx.getMessage());
                        }
                    }
                    if (deleted) {
                        System.out.println("AdminDeleteMain: File deleted successfully");
                        System.exit(0);
                    } else {
                        System.err.println("AdminDeleteMain: Failed to delete file");
                        System.exit(1);
                    }
                    break block9;
                }
                System.out.println("AdminDeleteMain: File does not exist");
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println("AdminDeleteMain: Exception occurred: " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

